/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renders;

import com.direwolf20.buildinggadgets.client.renderer.DireBufferBuilder;
import com.direwolf20.buildinggadgets.client.renderer.DireVertexBuffer;
import com.direwolf20.buildinggadgets.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.world.MockDelegationWorld;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;

public class CopyPasteRender
extends BaseRenderer
implements ITemplateProvider.IUpdateListener {
    private MultiVBORenderer renderBuffer;
    private int tickTrack = 0;
    private UUID lastRendered = null;

    @Override
    public void onTemplateUpdate(ITemplateProvider provider, ITemplateKey key, Template template) {
        if (provider.getId(key).equals(this.lastRendered)) {
            this.renderBuffer = null;
        }
    }

    @Override
    public void onTemplateUpdateSend(ITemplateProvider provider, ITemplateKey key, Template template) {
        this.onTemplateUpdate(provider, key, template);
    }

    @Override
    public void render(RenderLevelLastEvent evt, Player player, ItemStack heldItem) {
        super.render(evt, player, heldItem);
        Vec3 cameraView = CopyPasteRender.getMc().f_91063_.m_109153_().m_90583_();
        PoseStack stack = evt.getPoseStack();
        stack.m_85836_();
        stack.m_85837_(-cameraView.m_7096_(), -cameraView.m_7098_(), -cameraView.m_7094_());
        if (GadgetCopyPaste.getToolMode(heldItem) == GadgetCopyPaste.ToolMode.COPY) {
            this.renderBuffer = null;
            GadgetCopyPaste.getSelectedRegion(heldItem).ifPresent(region -> this.renderCopy(stack, (Region)region));
        } else {
            this.renderPaste(stack, cameraView, player, heldItem);
        }
        stack.m_85849_();
    }

    private void renderCopy(PoseStack matrix, Region region) {
        BlockPos startPos = region.getMin();
        BlockPos endPos = region.getMax();
        BlockPos blankPos = new BlockPos(0, 0, 0);
        if (startPos.equals((Object)blankPos) || endPos.equals((Object)blankPos)) {
            return;
        }
        int x = Math.min(startPos.m_123341_(), endPos.m_123341_());
        int y = Math.min(startPos.m_123342_(), endPos.m_123342_());
        int z = Math.min(startPos.m_123343_(), endPos.m_123343_());
        int dx = startPos.m_123341_() > endPos.m_123341_() ? startPos.m_123341_() + 1 : endPos.m_123341_() + 1;
        int dy = startPos.m_123342_() > endPos.m_123342_() ? startPos.m_123342_() + 1 : endPos.m_123342_() + 1;
        int dz = startPos.m_123343_() > endPos.m_123343_() ? startPos.m_123343_() + 1 : endPos.m_123343_() + 1;
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_(OurRenderTypes.m_110504_());
        matrix.m_85836_();
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        Matrix3f matrix3f = matrix.m_85850_().m_85864_();
        builder.m_85982_(matrix4f, (float)x, (float)y, (float)z).m_85950_(0.0f, 0.0f, 1.0f, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)dx, (float)y, (float)z).m_85950_(0.0f, 0.0f, 1.0f, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)x, (float)y, (float)z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)x, (float)dy, (float)z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)x, (float)y, (float)z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)x, (float)y, (float)dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)dx, (float)y, (float)z).m_85950_(0.0f, 1.0f, 0.0f, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)dx, (float)dy, (float)z).m_85950_(0.0f, 1.0f, 0.0f, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)dx, (float)dy, (float)z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)x, (float)dy, (float)z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)x, (float)dy, (float)z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)x, (float)dy, (float)dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)x, (float)dy, (float)dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)x, (float)y, (float)dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)x, (float)y, (float)dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)dx, (float)y, (float)dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)dx, (float)y, (float)dz).m_85950_(1.0f, 0.0f, 0.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)dx, (float)y, (float)z).m_85950_(1.0f, 0.0f, 0.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)x, (float)dy, (float)dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)dx, (float)dy, (float)dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)dx, (float)y, (float)dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)dx, (float)dy, (float)dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)dx, (float)dy, (float)z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(matrix4f, (float)dx, (float)dy, (float)dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_109911_();
        matrix.m_85849_();
    }

    private void renderPaste(PoseStack matrices, Vec3 cameraView, Player player, ItemStack heldItem) {
        Level world = player.f_19853_;
        world.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> heldItem.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> GadgetCopyPaste.getActivePos(player, heldItem).ifPresent(startPos -> {
            MockDelegationWorld fakeWorld = new MockDelegationWorld((LevelAccessor)world);
            BuildContext context = BuildContext.builder().player(player).stack(heldItem).build(fakeWorld);
            IBuildView view = provider.getTemplateForKey((ITemplateKey)key).createViewInContext(context);
            ArrayList<PlacementTarget> targets = new ArrayList<PlacementTarget>(view.estimateSize());
            for (PlacementTarget target : view) {
                if (!target.placeIn(context)) continue;
                targets.add(target);
            }
            UUID id = provider.getId((ITemplateKey)key);
            if (!id.equals(this.lastRendered)) {
                this.renderBuffer = null;
            }
            this.renderTargets(matrices, cameraView, context, (List<PlacementTarget>)targets, (BlockPos)startPos, view);
            this.lastRendered = id;
        })));
    }

    private void renderTargets(PoseStack matrix, Vec3 projectedView, BuildContext context, List<PlacementTarget> targets, BlockPos startPos, IBuildView view) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_(OurRenderTypes.m_110504_());
        matrix.m_85836_();
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        Matrix3f matrix3f = matrix.m_85850_().m_85864_();
        Region bb = view.getBoundingBox().translate(startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_());
        float x = bb.getMinX();
        float y = bb.getMinY();
        float z = bb.getMinZ();
        float dx = bb.getMaxX() + 1;
        float dy = bb.getMaxY() + 1;
        float dz = bb.getMaxZ() + 1;
        builder.m_85982_(matrix4f, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, dx, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, x, dy, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(matrix4f, x, y, dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(matrix4f, dx, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, dx, dy, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, dx, dy, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, x, dy, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, x, dy, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(matrix4f, x, dy, dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(matrix4f, x, dy, dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, x, y, dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, x, y, dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, dx, y, dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, dx, y, dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_85982_(matrix4f, dx, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_85982_(matrix4f, x, dy, dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, dx, dy, dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, dx, y, dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, dx, dy, dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix4f, dx, dy, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(matrix4f, dx, dy, dz).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_109911_();
        matrix.m_85849_();
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    public static class MultiVBORenderer
    implements Closeable {
        private static final int BUFFER_SIZE = 0x600000;
        private final ImmutableMap<RenderType, DireVertexBuffer> buffers;
        private final ImmutableMap<RenderType, DireBufferBuilder.State> sortCaches;

        public static MultiVBORenderer of(Consumer<MultiBufferSource> vertexProducer) {
            HashMap builders = Maps.newHashMap();
            vertexProducer.accept(rt -> (VertexConsumer)builders.computeIfAbsent(rt, _rt -> {
                DireBufferBuilder builder = new DireBufferBuilder(0x600000);
                builder.begin(_rt.m_173186_().f_166946_, _rt.m_110508_());
                return builder;
            }));
            HashMap sortCaches = Maps.newHashMap();
            Map buffers = Maps.transformEntries((Map)builders, (rt, builder) -> {
                Objects.requireNonNull(rt);
                Objects.requireNonNull(builder);
                sortCaches.put(rt, builder.getVertexState());
                builder.finishDrawing();
                VertexFormat fmt = rt.m_110508_();
                DireVertexBuffer vbo = new DireVertexBuffer(fmt);
                vbo.upload((DireBufferBuilder)((Object)builder));
                return vbo;
            });
            return new MultiVBORenderer(buffers, sortCaches);
        }

        protected MultiVBORenderer(Map<RenderType, DireVertexBuffer> buffers, Map<RenderType, DireBufferBuilder.State> sortCaches) {
            this.buffers = ImmutableMap.copyOf(buffers);
            this.sortCaches = ImmutableMap.copyOf(sortCaches);
        }

        public void sort(float x, float y, float z) {
            for (Map.Entry kv : this.sortCaches.entrySet()) {
                RenderType rt = (RenderType)kv.getKey();
                DireBufferBuilder.State state = (DireBufferBuilder.State)kv.getValue();
                DireBufferBuilder builder = new DireBufferBuilder(0x600000);
                builder.begin(rt.m_173186_().f_166946_, rt.m_110508_());
                builder.setVertexState(state);
                builder.sortVertexData(x, y, z);
                builder.finishDrawing();
                DireVertexBuffer vbo = (DireVertexBuffer)this.buffers.get((Object)rt);
                vbo.upload(builder);
            }
        }

        public void render(Matrix4f matrix) {
            this.buffers.forEach((rt, vbo) -> {
                VertexFormat fmt = rt.m_110508_();
                rt.m_110185_();
                vbo.bindBuffer();
                fmt.m_166912_();
                vbo.draw(matrix, rt.m_173186_().f_166946_);
                DireVertexBuffer.unbindBuffer();
                fmt.m_86024_();
                rt.m_110188_();
            });
        }

        @Override
        public void close() {
            this.buffers.values().forEach(DireVertexBuffer::close);
        }
    }
}

